/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.hudmods;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.blocks.FakeLavaBaseBlock;
import net.geforcemods.securitycraft.blocks.FakeWaterBaseBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.compat.hudmods.HudModHandler;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class TOPDataProvider
extends HudModHandler
implements Function<ITheOneProbe, Void> {
    private final String formatting = TextFormatting.BLUE.toString() + TextFormatting.ITALIC.toString();

    @Override
    @Nullable
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerBlockDisplayOverride((mode, probeInfo, player, world, blockState, data) -> {
            ItemStack displayStack;
            boolean edited = false;
            ItemStack item = ItemStack.field_190927_a;
            ItemStack itemLabel = ItemStack.field_190927_a;
            String labelText = "";
            String text = this.formatting + "Minecraft";
            if (blockState.func_177230_c() instanceof IDisguisable) {
                itemLabel = item = ((IDisguisable)blockState.func_177230_c()).getDisguisedStack((IBlockAccess)world, data.getPos());
                text = this.formatting + ((ModContainer)Loader.instance().getIndexedModList().get(item.func_77973_b().getRegistryName().func_110624_b())).getName();
                edited = true;
            } else if (blockState.func_177230_c() instanceof FakeLavaBaseBlock) {
                item = new ItemStack(Items.field_151129_at);
                labelText = Utils.localize("tile.lava.name", new Object[0]).func_150254_d();
                edited = true;
            } else if (blockState.func_177230_c() instanceof FakeWaterBaseBlock) {
                item = new ItemStack(Items.field_151131_as);
                labelText = Utils.localize("tile.water.name", new Object[0]).func_150254_d();
                edited = true;
            } else if (blockState.func_177230_c() instanceof IOverlayDisplay && (displayStack = ((IOverlayDisplay)blockState.func_177230_c()).getDisplayStack(world, blockState, data.getPos())) != null) {
                item = itemLabel = displayStack;
                edited = true;
            }
            if (edited) {
                IProbeInfo info = probeInfo.horizontal().item(item).vertical();
                if (itemLabel.func_190926_b()) {
                    info.text(labelText);
                } else {
                    info.itemLabel(itemLabel);
                }
                info.text(text);
                return true;
            }
            return false;
        });
        theOneProbe.registerProvider(new IProbeInfoProvider(){

            public String getID() {
                return "securitycraft:securitycraft";
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World level, IBlockState state, IProbeHitData data) {
                BlockPos pos = data.getPos();
                TOPDataProvider.this.addDisguisedOwnerModuleNameInfo(level, pos, state, state.func_177230_c(), level.func_175625_s(pos), player, string -> probeInfo.text(TextFormatting.GRAY + string), $ -> true);
            }
        });
        theOneProbe.registerEntityProvider(new IProbeInfoEntityProvider(){

            public String getID() {
                return "securitycraft:securitycraft";
            }

            public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo probeInfo, EntityPlayer player, World level, Entity entity, IProbeHitEntityData data) {
                TOPDataProvider.this.addEntityInfo(entity, player, string -> probeInfo.text(TextFormatting.GRAY + string), $ -> true);
            }
        });
        return null;
    }
}

